﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Chapter12.DL;
using Chapter12.OB;

namespace Chapter12.UI
{
    public partial class frmMain : Form
    {

        //public bool isXMLLoaded { get; set; }
        //public bool isDatabaseLoaded { get; set; }

        public frmMain()
        {
            InitializeComponent();
        }

        #region Button Click Events

        private void btnAllTransactions_Click(object sender, EventArgs e)
        {
            // Change tab control to All Transactions tab
            tabControl1.SelectedTab = tabPage1;
        }

        private void btnDeposits_Click(object sender, EventArgs e)
        {
            // Change tab control to Deposits tab
            tabControl1.SelectedTab = tabPage2;
        }

        private void btnWithdrawals_Click(object sender, EventArgs e)
        {
            // Change tab control to Withdrawals tab
            tabControl1.SelectedTab = tabPage3;
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            // Terminate application
            Application.Exit();
        }

        #endregion

        #region File MenuStrip Controls

        private void tsiLoadXML_Click(object sender, EventArgs e)
        {
            // Load up the application with data from an XML document
            BusinessLayer BL = new BusinessLayer(new XmlDal());
        }

        private void tsiLoadDatabase_Click(object sender, EventArgs e)
        {
            // Load up the application with data from the database
            BusinessLayer BL = new BusinessLayer(new SQLDAL());
            //DataTable dataTable = BL.GetCustomerTransactionsAll("2358304");

            //DataSet ds = new DataSet();
            //ds.WriteXml("myFile.xml");
            //dataTable.WriteXml("myfile.xml");

            //dtgAllTransactions.DataSource = BL.GetCustomerTransactionsAll("2358304");
            lstCustomerList.DataSource = BL.GetAllCustomerNames();
        }

        private void tsiSave_Click(object sender, EventArgs e)
        {
            // Save any changes made to the application
            // Even necessary?  Done by update command?
        }

        private void tsiExit_Click(object sender, EventArgs e)
        {
            // Terminate application
            Application.Exit();
        }

        #endregion

        #region Edit & Help MenuStrip Controls

        private void tsiAddCustomer_Click(object sender, EventArgs e)
        {
            // Add a new customer to the data
            frmAdd Addcustomer = new frmAdd();
            Addcustomer.ShowDialog();
        }

        private void tsiUpdateCustomer_Click(object sender, EventArgs e)
        {
            // Update a customer in the data
            frmUpdate UpdateCustomer = new frmUpdate();
            UpdateCustomer.ShowDialog();
        }

        private void tsiDeleteCustomer_Click(object sender, EventArgs e)
        {
            // Delete a customer from the data
            frmDelete DeleteCustomer = new frmDelete();
            DeleteCustomer.ShowDialog();
        }

        private void tsiAbout_Click(object sender, EventArgs e)
        {
            // Bring up a "how to" box?
            // Even necessary?
        }
        #endregion

        private void frmMain_Load(object sender, EventArgs e)
        {
            // Display welcome/instructional message
            frmWelcome Welcome = new frmWelcome();
            Welcome.ShowDialog();
            this.BringToFront();
        }
    }
}
