﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Data.SqlServerCe;
using System.Data;

namespace Chapter12.DL
{
    public interface IDal
    {
        List<string> GetAllCustomerNames();
        string GetCustomerFirstName(string cID);
        string GetCustomerLastName(string cID);
        void AddCustomer(string cID, string cFName, string cLName, string cSSN, string cBDay);
        void UpdateCustomer(string cID, string cFName, string cLName, string cSSN, string cBDay);
        void DeleteCustomer(string cID);
        DataTable GetCustomerTransactionsAll(string cID);
        DataTable GetCustomerWithdrawals(string cID);
        DataTable GetCustomerDeposits(string cID);
    }

    public class XmlDal:IDal
    {
        string _cs = "Data Source=|DataDirectory|\\CustomerInfo.sdf";

        public List<string> GetAllCustomerNames()
        {
            throw new NotImplementedException();
        }

        public string GetCustomerFirstName(string cID)
        {
            throw new NotImplementedException();
        }

        public string GetCustomerLastName(string cID)
        {
            throw new NotImplementedException();
        }

        public void AddCustomer(string cID, string cFName, string cLName, string cSSN, string cBDay)
        {
            throw new NotImplementedException();
        }

        public void UpdateCustomer(string cID, string cFName, string cLName, string cSSN, string cBDay)
        {
            throw new NotImplementedException();
        }

        public void DeleteCustomer(string cID)
        {
            throw new NotImplementedException();
        }

        public DataTable GetCustomerTransactionsAll(string cID)
        {
            throw new NotImplementedException();
        }

        public DataTable GetCustomerWithdrawals(string cID)
        {
            throw new NotImplementedException();
        }

        public DataTable GetCustomerDeposits(string cID)
        {
            throw new NotImplementedException();
        }
    }

    public class SQLDAL : IDal
    {
        string _cs = "Data Source=|DataDirectory|\\CustomerInfo.sdf";

        // Needs some fixing

        #region Customer Information

        // Get ALL Customer Names
        public List<string> GetAllCustomerNames()
        {
            List<string> lCustomerList = new List<string>();

            using (SqlCeConnection ceConn = new SqlCeConnection(_cs))
            {
                using (SqlCeCommand ceComm = new SqlCeCommand
                    ("SELECT CustFName, CustLName FROM CUSTOMER"))
                {
                    ceComm.Connection = ceConn;
                    ceComm.CommandType = System.Data.CommandType.Text;
                    ceConn.Open();

                    // Create reader object
                    SqlCeDataReader rdr = ceComm.ExecuteReader();

                    while (rdr.Read())
                    {
                        // Populate the List
                        lCustomerList.Add(rdr["CustFName"] + " " + rdr["CustLName"]);
                    }

                    ceConn.Close();
                }
            }
            return lCustomerList;
        }

        // Get Customer First Name
        public string GetCustomerFirstName(string cID)
        {
            string sCustomerFName = null;

            using (SqlCeConnection ceConn = new SqlCeConnection(_cs))
            {
                using (SqlCeCommand ceComm = new SqlCeCommand
                    ("SELECT CustFName FROM CUSTOMER WHERE CustID=@VAL1"))
                {
                    ceComm.Parameters.Add("@VAL1", System.Data.SqlDbType.NVarChar).Value = cID;
                    ceComm.Connection = ceConn;
                    ceComm.CommandType = System.Data.CommandType.Text;
                    ceComm.ExecuteNonQuery();
                    sCustomerFName = ceComm.ExecuteScalar().ToString();

                    ceConn.Close();
                }
            }
            return sCustomerFName;
        }

        // Get Customer Last Name
        public string GetCustomerLastName(string cID)
        {
            string sCustomerLName = null;

            using (SqlCeConnection ceConn = new SqlCeConnection(_cs))
            {
                using (SqlCeCommand ceComm = new SqlCeCommand
                    ("SELECT CustLName FROM CUSTOMER WHERE CustID=@VAL1"))
                {
                    ceComm.Parameters.Add("@VAL1", System.Data.SqlDbType.NVarChar).Value = cID;
                    ceComm.Connection = ceConn;
                    ceComm.CommandType = System.Data.CommandType.Text;
                    ceComm.ExecuteNonQuery();
                    sCustomerLName = ceComm.ExecuteScalar().ToString();

                    ceConn.Close();
                }
            }
            return sCustomerLName;
        }

        #endregion

        #region Insert/Update/Delete Customer

        // Add a new customer
        public void AddCustomer(string cID, string cFName, string cLName, string cSSN, string cBDay)
        {
            using (SqlCeConnection ceConn = new SqlCeConnection(_cs))
            {
                using (SqlCeCommand ceComm = new SqlCeCommand
                    ("INSERT INTO CUSTOMER (CustID,CustFName,CustLName,CustSSN,CustBDay) VALUES (@VAL1,@VAL2,@VAL3,@VAL4,@VAL5)"))
                {
                    ceComm.Parameters.Add("@VAL1", System.Data.SqlDbType.NVarChar).Value = cID;
                    ceComm.Parameters.Add("@VAL2", System.Data.SqlDbType.NVarChar).Value = cFName;
                    ceComm.Parameters.Add("@VAL3", System.Data.SqlDbType.NVarChar).Value = cLName;
                    ceComm.Parameters.Add("@VAL4", System.Data.SqlDbType.NVarChar).Value = cSSN;
                    ceComm.Parameters.Add("@VAL5", System.Data.SqlDbType.NVarChar).Value = cBDay;
                    ceComm.Connection = ceConn;
                    ceComm.CommandType = System.Data.CommandType.Text;
                    ceComm.ExecuteNonQuery();

                    ceConn.Close();
                }
            }
        }

        // Update a customer
        public void UpdateCustomer(string cID, string cFName, string cLName, string cSSN, string cBDay)
        {
            using (SqlCeConnection ceConn = new SqlCeConnection(_cs))
            {
                using (SqlCeCommand ceComm = new SqlCeCommand
                    ("UPDATE CUSTOMER SET CustFName=@VAL2,CustLName=@VAL3,CustSSN=@VAL4,CustBDay=@VAL5 WHERE CustID=@VAL1"))
                {
                    ceComm.Parameters.Add("@VAL1", System.Data.SqlDbType.NVarChar).Value = cID;
                    ceComm.Parameters.Add("@VAL2", System.Data.SqlDbType.NVarChar).Value = cFName;
                    ceComm.Parameters.Add("@VAL3", System.Data.SqlDbType.NVarChar).Value = cLName;
                    ceComm.Parameters.Add("@VAL4", System.Data.SqlDbType.NVarChar).Value = cSSN;
                    ceComm.Parameters.Add("@VAL5", System.Data.SqlDbType.NVarChar).Value = cBDay;
                    ceComm.Connection = ceConn;
                    ceComm.CommandType = System.Data.CommandType.Text;
                    ceComm.ExecuteNonQuery();

                    ceConn.Close();
                }
            }
        }

        // Delete a customer
        public void DeleteCustomer(string cID)
        {
            using (SqlCeConnection ceConn = new SqlCeConnection(_cs))
            {
                using (SqlCeCommand ceComm = new SqlCeCommand
                    ("DELETE FROM CUSTOMER WHERE CustID=VAL1"))
                {
                    ceComm.Parameters.Add("@VAL1", System.Data.SqlDbType.NVarChar).Value = cID;
                    ceComm.Connection = ceConn;
                    ceComm.CommandType = System.Data.CommandType.Text;
                    ceComm.ExecuteNonQuery();

                    ceConn.Close();
                }
            }
        }

        #endregion

        #region Transaction Information

        // Get Customer Transactions (ALL)
        public DataTable GetCustomerTransactionsAll(string cID)
        {
            DataTable dtTransactionsAll = new DataTable();

            using (SqlCeConnection ceConn = new SqlCeConnection(_cs))
            {
                using (SqlCeCommand ceComm = new SqlCeCommand
                    ("SELECT * FROM TRANSACTIONS WHERE CustID=@VAL1"))
                {
                    ceComm.Parameters.Add("@VAL1", System.Data.SqlDbType.NVarChar).Value = cID;
                    ceComm.Connection = ceConn;
                    ceComm.CommandType = System.Data.CommandType.Text;

                    //ceComm.ExecuteNonQuery();

                    // Create reader object
                    //SqlCeDataReader rdr = ceComm.ExecuteReader();
                    //SqlCeDataAdapter ada = ceComm.ExecuteReader();
                    //dtTransactionsAll;

                    //while (rdr.Read())
                    //{
                    //     Populate the DataTable
                    //    dtTransactionsAll
                    //    this.listBox1.Items.Add(rdr["ContactName"].ToString());
                    //}

                    // Define the data adapter and fill the DataTable
                    using (SqlCeDataAdapter ada = new SqlCeDataAdapter(ceComm))
                    {
                        ada.Fill(dtTransactionsAll);
                    } 

                    ceConn.Close();
                }
            }
            return dtTransactionsAll;
        }

        // Get Customer Withdrawals
        public DataTable GetCustomerWithdrawals(string cID)
        {
            DataTable dtWithdrawals = null;

            using (SqlCeConnection ceConn = new SqlCeConnection(_cs))
            {
                using (SqlCeCommand ceComm = new SqlCeCommand
                    ("SELECT * FROM TRANSACTIONS WHERE CustID=@VAL1 AND TransType='Withdrawal'"))
                {
                    ceComm.Parameters.Add("@VAL1", System.Data.SqlDbType.NVarChar).Value = cID;
                    ceComm.Connection = ceConn;
                    ceComm.CommandType = System.Data.CommandType.Text;
                    ceComm.ExecuteNonQuery();

                    // Define the data adapter and fill the DataTable
                    using (SqlCeDataAdapter ada = new SqlCeDataAdapter(ceComm))
                    {
                        ada.Fill(dtWithdrawals);
                    }

                    ceConn.Close();
                }
            }
            return dtWithdrawals;
        }

        // Get Customer Deposits
        public DataTable GetCustomerDeposits(string cID)
        {
            DataTable dtDeposits = null;

            using (SqlCeConnection ceConn = new SqlCeConnection(_cs))
            {
                using (SqlCeCommand ceComm = new SqlCeCommand
                    ("SELECT * FROM TRANSACTIONS WHERE CustID=@VAL1 AND TransType='Deposit'"))
                {
                    ceComm.Parameters.Add("@VAL1", System.Data.SqlDbType.NVarChar).Value = cID;
                    ceComm.Connection = ceConn;
                    ceComm.CommandType = System.Data.CommandType.Text;
                    ceComm.ExecuteNonQuery();

                    // Define the data adapter and fill the DataTable
                    using (SqlCeDataAdapter ada = new SqlCeDataAdapter(ceComm))
                    {
                        ada.Fill(dtDeposits);
                    }

                    ceConn.Close();
                }
            }
            return dtDeposits;
        }

        #endregion

    }
}
